/*:
 * @target MZ
 * @plugindesc Open Options as overlay without leaving current scene
 * @author HS
 *
 * @command Open
 * @text Open Options Overlay
 * @desc 現在のシーンの上にオプションを重ねて開く
 *
 * @command Close
 * @text Close Options Overlay
 * @desc 重ね表示のオプションを閉じる
 */
(() => {
  const PLUGIN_NAME = "HS_OptionsOverlay";

  function openOverlay() {
    const scene = SceneManager._scene;
    if (!scene || scene._hsOptionsWin) return;

    const rect = new Rectangle(0, 0, Graphics.boxWidth, Graphics.boxHeight);
    const win = new Window_Options(rect);
    scene._hsOptionsWin = win;

    // キャンセルで閉じる
    win.setHandler('cancel', () => {
      SoundManager.playCancel();
      if (scene._windowLayer && win.parent === scene._windowLayer) {
        scene._windowLayer.removeChild(win);
      } else if (win.parent) {
        win.parent.removeChild(win);
      }
      win.deactivate();
      win.close();
      scene._hsOptionsWin = null;
      scene.activate?.();
    });

    // 最前面のウィンドウレイヤーへ追加（これが正解。removeChildもここから）
    if (scene._windowLayer) scene._windowLayer.addChild(win);
    else scene.addWindow?.(win) ?? scene.addChild(win);

    win.openness = 0;
    win.open();
    win.activate();
    win.select(0);
  }

  function closeOverlay() {
    const scene = SceneManager._scene;
    const win = scene?._hsOptionsWin;
    if (win) win.callHandler('cancel');
  }

  PluginManager.registerCommand(PLUGIN_NAME, "Open", openOverlay);
  PluginManager.registerCommand(PLUGIN_NAME, "Close", closeOverlay);

  // シーンが変わる時に掃除
  const _terminate = Scene_Base.prototype.terminate;
  Scene_Base.prototype.terminate = function() {
    const win = this._hsOptionsWin;
    if (win && win.parent) win.parent.removeChild(win);
    this._hsOptionsWin = null;
    _terminate.call(this);
  };
})();
